function valic=infcr(ic,ll,nobs,nvar,dim)
% PURPOSE: calculates information criterion
%---------------------------------------------------
% USAGE:  infocr=infcr(ic,sigr,nobs,nvar)
% where:    ic    = type of information criterion
%                   (AIC or BIC or HQ)
%           ll   = loglikelihood or log of RSS
%           sigr = variance of estimated residuals
%           nobs = number of observations (already adjusted)
%           nvar = number of variables
%
%---------------------------------------------------
%
% written by:
% Frauke Schleer
% schleer@zew.de

switch ic
    case 'AIC'
        switch dim
            case 'multi'
                valic= -2*ll/nobs+2*(nvar)/nobs; %EViews % multivariate case
            case 'uni'
                valic=ll+2*nvar/nobs; %JMulTi % univariate case
        end
    case 'BIC'
        switch dim
            case 'multi'
                valic= -2*ll/nobs+nvar*log(nobs)/nobs;
            case 'uni'
                valic=ll+nvar*log(nobs)/nobs;
        end
    case 'HQ'
        c=1.3;
        switch dim
            case 'multi'
                valic=-2*ll/nobs+2*nvar*c*log(log(nobs))/nobs;
            case 'uni'
                valic=ll+2*nvar*c*log(log(nobs))/nobs;
        end
end